#!/bin/bash

#
# GENERAL CONFIG
#
UTBINARY="$PWD/ucc-bin"
SLEEPTIME="10"
#
# if you use ucc to start set "server"
# else ""
#
UCCOPTIONS="server"

#
# dont use ~/.unrealtournament/
#
OPTIONS="-nohomedir"

#
# we want to play TacticalOps
#
GAMETYPE="s_SWAT.s_SWATGame"

#
# Startmap ( dont use entry.unr/intro.unr/creditsto.unr here )
#
STARTMAP="TO-Blister.unr"

#
# INI FILES
#
SERVERINI="Server.ini"
USERINI="ServerUser.ini"

#
# LOG OPTIONS
#
LOGPREFIX="TacticalOpsServer"
SYSTEMLOGS="../Logs/system"

#
# USEFULL OPTIONS
#
# mp=<Maxplayers>
# multihome=<bind server>
#
# sample: OPTIONS="mp=10 multihome=192.168.1.2"
#
OPTIONS=""


while true; do
    SD=$(date +'%Y-%m-%dT%H-%M');
    CMDLINE="$UTBINARY $UCCOPTIONS $STARTMAP?game=$GAMETYPE INI=$SERVERINI USERINI=$USERINI LOG=$SYSTEMLOGS/$LOGPREFIX-$SD.log $OPTIONS";

    echo $CMDLINE;
    nice $CMDLINE;

    echo -e "\n\nyou have 10s to kill this script\n\n";
    sleep $SLEEPTIME;
done

