class IUTDCCheck extends UTDCCommon;

var int		MeasuredSpeed;		// UTDC measured CPU speed.
var int		UTSpeed;			// UT measured CPU speed.
var string	WindowsVersion;		// Windows version.
var string	CommandLine;		// Client command line.
var string	ClientUTVersion;	// Client UT version.

var bool	bNtDllPresent;		// ntdll loaded.
var bool	bNtDllMemCopy;		// Memory ntdll image.

var int		CoreBaseAddr;		// Core.dll base address.
var int		EngineBaseAddr;		// Engine.dll base address.
var int		RenderBaseAddr;		// Render.dll base address.
var int		GalaxyBaseAddr;		// Galaxy.dll base address.
var int		UTDCBaseAddr;		// UTDCx.dll base address.
var string	CoreMD5;			// Render.dll MD5 hash.
var string	EngineMD5;			// Engine.dll MD5 hash.
var string	RenderMD5;			// Render.dll MD5 hash.
var string	GalaxyMD5;			// Galaxy.dll MD5 hash.
var string	UTDCMD5;			// UTDCx.dll MD5 hash.

var string	RenderDrvFile;		// Render driver dll.
var string	RenderDrvMD5;		// Render driver MD5 hash.

var string	MACHash;			// First NIC MAC hash.
var string	NICDescHash;		// First NIC desc. hash..
var int		NICCount;			// NIC Count.

var bool	bLogged;			// True when a memory check have detected a hook.
var bool	bLoggedUFuncCall;	// True when a an illegal ufunction call have been logged.

var string	CpuInfo;

function AddEventCatcher(IUTDCCheckEvent Check);

function ScreenShot();

function MemoryCheckWithTimeout(int RetryInterval, int TryCount, int CheckType);
function MemoryCheck(int CheckType);

function FindWindowWithTimeout(int RetryInterval, int TryCount, string Title, int Index);
function FindWindow(string Title, int Index);

function FileCheckWithTimeout(int RetryInterval, int TryCount, string FileName, int Index);
function FileCheck(string FileName, int Index);

function ModuleCheckWithTimeout(int RetryInterval, int TryCount, string Module, int Index, bool bCheckCode, bool bCheckImports, bool bCheckExports, bool bCheckVTBL);
function ModuleCheck(string Module, int Index, bool bCheckCode, bool bCheckImports, bool bCheckExports, bool bCheckVTBL);

function CheckAddrWithTimeout(int RetryInterval, int TryCount, int Addr, int Index);
function CheckAddr(int Addr, int Index);

function GetMACHash(int NICIndex);

function FadeUTDCLogo();

function StartServerCheck(int CheckInterval);
function StartClientCheck(int CheckInterval);

function KickPlayer(int KickInSeconds);


